

/* Future Performance Optimizations
 - only collision detection character if it is within the bounding box of a mark
 */

/* Interesting Ideas
 - could the segment's point data be a single array that is shared between segments?
 - segment length increases with each segment drawn?
 - ball makes a drawing that it can also erase?
 */


// 
// add simulated gravity changes see: http://www.howtoprogramgames.com/2012/04/ipad-accelerometer-in-processing-js/
// add softer + harder?
//

geom g = new geom();
boolean debug = true;

ArrayList <mark> marks = new ArrayList <mark> ();
ArrayList <segment> segments = new ArrayList <segment> ();
PVector segStartPos = new PVector(0, 0);
PVector center;

int savedMillis;

character ball;

final int segment_min_length = 30;
int segment_distance_travelled = 0;

void setup() {
  size(640, 920);
  frameRate(60);
 
  center = new PVector(width/2, height/2);
  ball = new character();
}

void draw() {
  sim();
  render();
}

void sim() {
  
  int times = int((millis() - savedMillis) / 16);
  
  for(int i = 0; i <= times; i++){
    ball.sim(marks);
    savedMillis = millis();
  }
  
}

void render() {

  background(0);
  strokeWeight(4);

  if (mousePressed) renderMousePosition(); 

  // render existing marks
  for (mark m : marks) {
    for (segment s : m.segments) {

      switch(s.strength) {
      case 0:
        stroke(m.shade);
        break;

      case 1:
        stroke(0, 255, 0);
        break;

      case 2:
        stroke(255, 0, 0);
        break;
      }

      strokeWeight(4 + (s.hits * 2));
      line(s.start.x, s.start.y, s.end.x, s.end.y);
    }
  }

  // preview segment
  strokeWeight(4);
  stroke(155, 155, 0);
  for (segment s : segments) {
    line(s.start.x, s.start.y, s.end.x, s.end.y);
  }

  ball.render();

  if (debug) {
    ball.debugRender();
    ball.renderCollisions();
  }
}

void mousePressed() { // remember the starting point for our new segment
  resetSegmentStartingPoint();
}

void mouseDragged() { // create a new segment based on segment_min_length and add it to our segments ArrayList
  formSegments();
}

void mouseReleased() { // create a mark from our segments and add the mark to our marks ArrayList, clear our temp. list of segments
  if (segments.size() > 0) marks.add(saveSegmentsAsMark());
}

void keyPressed() {

  switch(key) {
  case 'd':
    debug = !debug;
    break;
  case ' ':
    //rotateGravity = !rotateGravity;
    break;
  }
}

void resetSegmentStartingPoint() {
  segStartPos = new PVector(mouseX, mouseY);
}

void formSegments() {
  segment_distance_travelled += dist(pmouseX, pmouseY, mouseX, mouseY);
  if (segment_distance_travelled >= segment_min_length) {
    segments.add( new segment(segStartPos.x, segStartPos.y, mouseX, mouseY, int(random(0, 4))) );
    resetSegmentStartingPoint();
    segment_distance_travelled = 0;
  }
}

mark saveSegmentsAsMark() {
  if (segments.size() > 0) {
    ArrayList <segment> segmentsToAdd = (ArrayList) segments.clone();
    segments.clear();
    return new mark(new ArrayList(segmentsToAdd));
  }
  return null;
}

void renderMousePosition() {
  stroke(255, 0, 0);
  line(segStartPos.x, segStartPos.y, mouseX, mouseY);
}

